/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.AABBInvoker;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="RaycastAPI", value="raycast")
public class RaycastAPI {
    private final Avatar owner;

    public RaycastAPI(Avatar owner) {
        this.owner = owner;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class, String.class, String.class}, argumentNames={"start", "end", "blockCastType", "fluidCastType"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class, String.class, String.class}, argumentNames={"startX", "startY", "startZ", "end", "blockCastType", "fluidCastType"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class, String.class, String.class}, argumentNames={"start", "endX", "endY", "endZ", "blockCastType", "fluidCastType"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class, String.class}, argumentNames={"startX", "startY", "startZ", "endX", "endY", "endZ", "blockCastType", "fluidCastType"})}, value="raycast.block")
    public Object[] block(Object x, Object y, Object z, Object w, Object t, Object h, String blockCastType, String fluidCastType) {
        ClipContext.Fluid fluidContext;
        ClipContext.Block blockContext;
        Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> parseResult = LuaUtils.parse2Vec3("block", new Class[]{String.class, String.class}, x, y, z, w, t, h, blockCastType, fluidCastType);
        FiguraVec3 start = (FiguraVec3)((Pair)parseResult.getFirst()).getFirst();
        FiguraVec3 end = (FiguraVec3)((Pair)parseResult.getFirst()).getSecond();
        blockCastType = (String)((Object[])parseResult.getSecond())[0];
        fluidCastType = (String)((Object[])parseResult.getSecond())[1];
        try {
            blockContext = blockCastType != null ? ClipContext.Block.valueOf((String)blockCastType.toUpperCase(Locale.US)) : ClipContext.Block.COLLIDER;
        }
        catch (IllegalArgumentException e) {
            throw new LuaError("Invalid blockRaycastType provided");
        }
        try {
            fluidContext = fluidCastType != null ? ClipContext.Fluid.valueOf((String)fluidCastType.toUpperCase(Locale.US)) : ClipContext.Fluid.NONE;
        }
        catch (IllegalArgumentException e) {
            throw new LuaError("Invalid fluidRaycastType provided");
        }
        BlockHitResult result = WorldAPI.getCurrentWorld().clip(new ClipContext(start.asVec3(), end.asVec3(), blockContext, fluidContext, (Entity)new Marker(EntityType.MARKER, WorldAPI.getCurrentWorld())));
        return LuaUtils.parseBlockHitResult((HitResult)result);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class, LuaFunction.class}, argumentNames={"start", "end", "predicate"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class, LuaFunction.class}, argumentNames={"startX", "startY", "startZ", "end", "predicate"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class, LuaFunction.class}, argumentNames={"start", "endX", "endY", "endZ", "predicate"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, LuaFunction.class}, argumentNames={"startX", "startY", "startZ", "endX", "endY", "endZ", "predicate"})}, value="raycast.entity")
    public Object[] entity(Object x, Object y, Object z, Object w, Object t, Double h, LuaFunction predicate) {
        Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> pair = LuaUtils.parse2Vec3("entity", new Class[]{LuaFunction.class}, x, y, z, w, t, h, predicate);
        FiguraVec3 start = (FiguraVec3)((Pair)pair.getFirst()).getFirst();
        FiguraVec3 end = (FiguraVec3)((Pair)pair.getFirst()).getSecond();
        LuaFunction fn = (LuaFunction)((Object[])pair.getSecond())[0];
        Predicate<Entity> entityPredicate = entity -> {
            if (fn == null) {
                return true;
            }
            LuaValue result = fn.invoke(this.owner.luaRuntime.typeManager.javaToLua(EntityAPI.wrap(entity))).arg1();
            return (!result.isboolean() || result.checkboolean()) && !result.isnil();
        };
        EntityHitResult result = ProjectileUtil.getEntityHitResult((Entity)new Marker(EntityType.MARKER, WorldAPI.getCurrentWorld()), (Vec3)start.asVec3(), (Vec3)end.asVec3(), (AABB)new AABB(start.asVec3(), end.asVec3()), entityPredicate, (double)Double.MAX_VALUE);
        if (result != null) {
            return new Object[]{EntityAPI.wrap(result.getEntity()), FiguraVec3.fromVec3(result.getLocation())};
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class, LuaTable.class}, argumentNames={"start", "end", "aabbs"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class, LuaTable.class}, argumentNames={"startX", "startY", "startZ", "end", "aabbs"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class, LuaTable.class}, argumentNames={"start", "endX", "endY", "endZ", "aabbs"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, LuaTable.class}, argumentNames={"startX", "startY", "startZ", "endX", "endY", "endZ", "aabbs"})}, value="raycast.aabb")
    public Object[] aabb(Object x, Object y, Object z, Object w, Object t, Object h, LuaTable aabbs) {
        Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> pair = LuaUtils.parse2Vec3("aabb", new Class[]{LuaTable.class}, x, y, z, w, t, h, aabbs);
        Vec3 start = ((FiguraVec3)((Pair)pair.getFirst()).getFirst()).asVec3();
        Vec3 end = ((FiguraVec3)((Pair)pair.getFirst()).getSecond()).asVec3();
        aabbs = (LuaTable)((Object[])pair.getSecond())[0];
        if (aabbs == null) {
            throw new LuaError("Illegal argument to aabb(): Expected LuaTable, recieved nil");
        }
        ArrayList<AABB> aabbList = new ArrayList<AABB>();
        for (int i = 1; i <= aabbs.length(); ++i) {
            LuaValue arg = aabbs.get(i);
            if (!arg.istable()) {
                throw new LuaError("Illegal argument at array index " + i + ": Expected table, recieved " + arg.typename() + " (" + arg.toString() + ")");
            }
            LuaValue min = arg.get(1);
            if (!min.isuserdata(FiguraVec3.class)) {
                throw new LuaError("Illegal argument to AABB at array index " + i + " at index 1: Expected Vector3, recieved " + min.typename() + " (" + min.toString() + ")");
            }
            LuaValue max = arg.get(2);
            if (!max.isuserdata(FiguraVec3.class)) {
                throw new LuaError("Illegal argument to AABB at array index " + i + " at index 2: Expected Vector3, recieved " + max.typename() + " (" + max.toString() + ")");
            }
            aabbList.add(new AABB(((FiguraVec3)min.checkuserdata(FiguraVec3.class)).asVec3(), ((FiguraVec3)max.checkuserdata(FiguraVec3.class)).asVec3()));
        }
        double d = Double.MAX_VALUE;
        int index = -1;
        Pair<Vec3, Direction> result = null;
        for (int i = 0; i < aabbList.size(); ++i) {
            Vec3 position;
            double e;
            AABB box = (AABB)aabbList.get(i);
            Optional<Pair<Vec3, Direction>> optional = this.clipAABB(box, start, end);
            if (box.contains(start)) {
                if (!(d >= 0.0)) continue;
                index = i + 1;
                result = optional.orElse((Pair<Vec3, Direction>)Pair.of((Object)start, null));
                d = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((e = start.distanceToSqr(position = (Vec3)optional.get().getFirst())) < d) && d != 0.0) continue;
            index = i + 1;
            result = optional.get();
            d = e;
        }
        if (index == -1) {
            return null;
        }
        return new Object[]{aabbs.get(index), FiguraVec3.fromVec3((Vec3)result.getFirst()), result.getSecond() != null ? ((Direction)result.getSecond()).getName() : null, index};
    }

    public Optional<Pair<Vec3, Direction>> clipAABB(AABB aabb, Vec3 min, Vec3 max) {
        double[] ds = new double[]{1.0};
        double d = max.x - min.x;
        double e = max.y - min.y;
        double f = max.z - min.z;
        Direction direction = AABBInvoker.getDirection(aabb, min, ds, null, d, e, f);
        if (direction == null) {
            return Optional.empty();
        }
        double g = ds[0];
        return Optional.of(Pair.of((Object)min.add(g * d, g * e, g * f), (Object)direction));
    }
}

